CREATE TABLE units (
  id INT AUTO_INCREMENT PRIMARY KEY,
  slug VARCHAR(120) NOT NULL UNIQUE,
  name VARCHAR(120) NOT NULL UNIQUE,
  alias VARCHAR(120) NULL,
  building VARCHAR(120) NULL,
  floor VARCHAR(60) NULL,
  description_short VARCHAR(255) NULL,
  description_steps TEXT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  priority INT NOT NULL DEFAULT 0,
  updated_at DATETIME NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE unit_media (
  id INT AUTO_INCREMENT PRIMARY KEY,
  unit_id INT NOT NULL,
  type ENUM('video','image') NOT NULL,
  url VARCHAR(255) NOT NULL,
  title VARCHAR(120) NULL,
  is_primary TINYINT(1) NOT NULL DEFAULT 0,
  duration_seconds INT NULL,
  FOREIGN KEY (unit_id) REFERENCES units(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE unit_synonyms (
  id INT AUTO_INCREMENT PRIMARY KEY,
  unit_id INT NOT NULL,
  term VARCHAR(120) NOT NULL,
  UNIQUE KEY uniq_unit_term (unit_id, term),
  FOREIGN KEY (unit_id) REFERENCES units(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE search_logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  query_text VARCHAR(255) NOT NULL,
  matched_unit_id INT NULL,
  confidence DECIMAL(4,2) NOT NULL DEFAULT 0.00,
  source ENUM('voice','text') NOT NULL DEFAULT 'text',
  created_at DATETIME NOT NULL,
  FOREIGN KEY (matched_unit_id) REFERENCES units(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Índices de búsqueda
ALTER TABLE units ADD FULLTEXT idx_ft_units (name, alias, description_short);

-- Datos semilla de ejemplo
INSERT INTO units(slug,name,alias,building,floor,description_short,description_steps,priority) VALUES
('nuevo-ingreso','Nuevo Ingreso','Admisiones','Edificio A','1.º piso','Atención a estudiantes de primer ingreso',
'Entra por el Portón Principal.
Avanza recto hasta el lobby.
Sube al 1.º piso por las gradas de la derecha.
Gira a la izquierda y sigue los rótulos “Admisiones”.
La ventanilla de Nuevo Ingreso está al fondo, a la derecha.',10),
('registro-academico','Registro Académico',NULL,'Edificio B','2.º piso','Constancias y certificaciones',
'Desde el lobby central, toma las gradas al 2.º piso.
Gira a la derecha y sigue los rótulos "Registro".
La ventanilla está a mitad del pasillo.',8),
('caja','Caja','Pagos','Edificio Central','Planta baja','Pagos y aranceles',
'Entra por el Portón Principal.
Sigue a la izquierda hacia el pasillo de servicios.
Caja está al fondo, ventanillas 1–3.',7),
('biblioteca-central','Biblioteca Central','Biblioteca','Edificio C','3.º piso','Préstamo y consulta de libros',
'Desde el jardín central, ubica el Edificio C.
Toma el ascensor al 3.º piso.
Sigue el pasillo principal hasta el fondo.',6);

INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'nuevo ingreso' FROM units WHERE slug='nuevo-ingreso';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'admisiones' FROM units WHERE slug='nuevo-ingreso';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'inscripcion' FROM units WHERE slug='nuevo-ingreso';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'matricula' FROM units WHERE slug='nuevo-ingreso';

INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'registro' FROM units WHERE slug='registro-academico';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'certificaciones' FROM units WHERE slug='registro-academico';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'constancias' FROM units WHERE slug='registro-academico';

INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'pagos' FROM units WHERE slug='caja';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'aranceles' FROM units WHERE slug='caja';

INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'biblioteca' FROM units WHERE slug='biblioteca-central';
INSERT INTO unit_synonyms(unit_id,term)
SELECT id,'libros' FROM units WHERE slug='biblioteca-central';

-- Media de ejemplo (YouTube embed o MP4 directo)
INSERT INTO unit_media(unit_id,type,url,title,is_primary)
SELECT id,'video','https://www.youtube.com/embed/dQw4w9WgXcQ','Ruta a Nuevo Ingreso',1 FROM units WHERE slug='nuevo-ingreso';
