<?php
$config = require __DIR__ . '/Config/config.php';

require __DIR__ . '/App/Core/Autoloader.php';
\App\Core\Autoloader::register();

use App\Controllers\HomeController;
use App\Controllers\SearchController;
use App\Controllers\UnitController;
use App\Controllers\InfoController;
//admin
  use App\Controllers\Admin\LoginController;
  use App\Controllers\Admin\DashboardController;
  use App\Controllers\Admin\UnitsController;
  use App\Services\Admin\AuthService;
  use App\Controllers\Admin\ZonasController;
  use App\Controllers\Admin\ZonasRapidasController;
  use App\Controllers\Admin\EstadisticoController;

$basePath = $config['base_path'] ?? '';
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
if ($basePath && str_starts_with($uri, $basePath)) {
  $uri = substr($uri, strlen($basePath));
}

$method = $_SERVER['REQUEST_METHOD'];
// Ruteo simple
if ($uri === '/' || $uri === '') {
  (new HomeController($config))->index();
} elseif ($uri === '/buscar' && in_array($method, ['GET','POST'])) {
  (new SearchController($config))->buscar();
} elseif (preg_match('#^/unidad/([a-z0-9\-]+)$#', $uri, $m)) {
  (new UnitController($config))->ver($m[1]);
} elseif ($uri === '/salud') {
  header('Content-Type: text/plain'); echo 'OK'; 
} elseif (preg_match('#^/categoria/([a-z0-9\-]+)$#', $uri, $m)) {
  (new \App\Controllers\AreaController($config))->ver($m[1]);
} elseif ($uri === '/unidades') {
  (new \App\Controllers\AreaController($config))->todas();
} elseif ($uri === '/instrucciones') {
  (new InfoController($config))->instrucciones();
} elseif (preg_match('#^/admin(?:/(.*))?$#', $uri, $m)) {
  $subpath = $m[1] ?? '';

  $auth    = new AuthService($config);
  $toLogin = rtrim($basePath, '/') . '/admin/login';

  // --- Rutas públicas (no requieren sesión) ---
  if ($subpath === '' || $subpath === 'login') {
    (new LoginController($config))->login();
    return;
  }
  if ($subpath === 'logout') {
    (new LoginController($config))->logout();
    return;
  }

  // --- Rutas protegidas (requieren sesión) ---
  if (!$auth->check()) {
    header("Location: $toLogin");
    exit;
  }
  
    // --- API Admin (protegida) ---
  if (str_starts_with($subpath, 'api/stats')) {
    // $subpath puede ser: 'api/stats/searches', 'api/stats/no-result', etc.
    $metric = '';
    if (preg_match('#^api/stats(?:/([^/]+))?$#', $subpath, $mm)) {
      $metric = $mm[1] ?? '';
    }

    // Crea el controlador API
    $api = new \App\Controllers\Admin\StatsApiController($config);

    // Cabeceras JSON comunes
    header('Content-Type: application/json; charset=utf-8');

    switch ($metric) {
      case 'searches':         $api->searches($_GET);         break;
      case 'no-result':        $api->noResult($_GET);         break;
      case 'top-units':        $api->topUnits($_GET);         break;
      case 'funnel':           $api->funnel($_GET);           break;
      case 'ctr':              $api->ctr($_GET);              break;
      case 'route-requests':   $api->routeRequests($_GET);    break;
      case 'kiosk-sessions':   $api->kioskSessions($_GET);    break;
      case 'catalog-hygiene':  $api->catalogHygiene($_GET);   break;
      case 'security':         $api->security($_GET);         break;
      case 'usage-by-channel': $api->usageByChannel($_GET);   break;
      case 'input-mode':       $api->inputMode($_GET);        break;

      // (opcional) batch
      case 'batch':            $api->batch($_GET);            break;

      default:
        http_response_code(404);
        echo json_encode(['ok'=>false, 'error'=>'Endpoint no encontrado']);
    }
    return; // Importante: no seguir evaluando otras rutas
  }


  if ($subpath === 'dashboard') {
    (new DashboardController($config))->index();
  } elseif (str_starts_with($subpath, 'units')) {
    (new UnitsController($config))->index();
  } elseif ($subpath === 'zonas') {
    (new ZonasController($config))->index();
  } elseif ($subpath === 'zonas-rapidas') {
    (new ZonasRapidasController($config))->index();
  } elseif ($subpath === 'estadistico-general') {
    (new EstadisticoController($config))->index();
  } else {
    http_response_code(404);
    echo 'Admin 404';
  }

} else {
  http_response_code(404); echo '404';
}
