<!-- Page Title -->
<div class="page-title dark-background" style="background-image: url(<?= $basePath ?>/assets/img/page-title-bg.jpg);">
  <div class="container position-relative">
    <h1><?= htmlspecialchars($title ?? 'Unidades') ?></h1>
    <nav class="breadcrumbs">
      <ol>
        <li><a href="<?= $basePath ?>/">Inicio</a></li>
        <li class="current"><?= htmlspecialchars($title ?? 'Unidades') ?></li>
      </ol>
    </nav>
  </div>
</div>


<div class="container mt-4">
  <h1><?= htmlspecialchars($title) ?></h1>
  <div class="row">
    <?php foreach ($unitsa as $u): ?>
      <div class="col-md-4 mb-3">
        <div class="card h-100">
          <?php if (!empty($u['image'])): ?>
            <img src="<?= htmlspecialchars($u['image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($u['name']) ?>" loading="lazy">
          <?php endif; ?>
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($u['name']) ?></h5>
            <p class="card-text"><?= htmlspecialchars($u['area_name'] ?? '-') ?></p>
            <a href="<?= $basePath ?>/unidad/<?= htmlspecialchars($u['slug']) ?>" class="btn btn-primary">Ver detalles</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <!-- paginación -->
  <?php $pages = ceil($total / $limit); ?>
  <?php if ($pages > 1): ?>
    <nav>
      <ul class="pagination">
        <?php for ($i = 1; $i <= $pages; $i++): ?>
          <li class="page-item <?= $i == $page ? 'active' : '' ?>">
            <a class="page-link" href="<?= $basePath ?>/unidades?page=<?= $i ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>
      </ul>
    </nav>
  <?php endif; ?>
</div>
