<?php
/** @var array $unit */
/** @var array $media */
?>

<!-- Page Title -->
<div class="page-title dark-background" style="background-image: url(<?= $basePath ?>/assets/img/page-title-bg.jpg);">
  <div class="container position-relative">
    <h1><?= htmlspecialchars($unit['name']) ?></h1>
    <nav class="breadcrumbs">
      <ol>
        <li><a href="<?= $basePath ?>/">Inicio</a></li>
        <li><a href="<?= $basePath ?>/unidades">Todas</a></li>
        <?php if (!empty($unit['area_name'])): ?>
          <li><a href="<?= $basePath ?>/categoria/<?= $unit['area_slug'] ?>"><?= htmlspecialchars($unit['area_name']) ?></a></li>
        <?php endif; ?>
        <li class="current"><?= htmlspecialchars($unit['name']) ?></li>
      </ol>
    </nav>
  </div>
</div>

<!-- Detalle de la unidad -->
<section id="unit-detail" class="unit-detail section">
  <div class="container" data-aos="fade-up">

    <div class="row justify-content-around gy-4">
      
      <!-- Columna izquierda: Video -->
      <div class="features-image col-lg-6" data-aos="fade-up" data-aos-delay="100">
        <?php if (!empty($media)):
          $m = $media[0] ?? null;
          if (($m['type'] ?? '') === 'video'):
            $url  = $m['url'] ?? '';
            $isYT = preg_match('~youtu\.be|youtube\.com~', $url); ?>
            <div class="player">
              <?php if ($isYT): ?>
                <iframe loading="lazy" width="560" height="315"
                  src="<?= htmlspecialchars($url) ?>" frameborder="0"
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                  allowfullscreen></iframe>
              <?php else: ?>
                <video controls preload="metadata" width="100%">
                  <source src="<?= htmlspecialchars($url) ?>" type="video/mp4">
                  Tu navegador no soporta video HTML5.
                </video>
              <?php endif; ?>
            </div>
        <?php endif; endif; ?>
      </div>

      <!-- Columna derecha: Instrucciones + QR -->
      <div class="col-lg-5 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
        <h3>Descripción:</h3>
        <?php if (!empty($unit['description_short'])): ?>
          <p class="muted"><?= htmlspecialchars($unit['description_short']) ?></p>
        <?php endif; ?>

        <?php if (!empty($unit['description_steps'])):
          $steps = preg_split('/\r?\n/', trim($unit['description_steps']));
        ?>
          <h3 style="color: #2F597A;">Indicaciones</h3>
          <ol class="steps">
            <?php foreach ($steps as $s): if (trim($s) !== ''): ?>
              <li><?= htmlspecialchars($s) ?></li>
            <?php endif; endforeach; ?>
          </ol>
        <?php endif; ?>

        <div class="grid mt-3">
          <div><strong>Edificio:</strong> <?= htmlspecialchars($unit['building'] ?? '-') ?></div>
          <div><strong>Piso:</strong> <?= htmlspecialchars($unit['floor'] ?? '-') ?></div>
        </div>

        <div class="actions mt-3" style="display:none;">
          <a href="<?= $basePath ?>/" class="btn btn-warning">Nueva búsqueda</a>
        </div>
      </div>
              <!-- QR dinámico -->
        <div class="col-lg-5 qr-section text-center mt-4">
          <h4>Escanea el QR para abrir en tu móvil</h4>
          <img src="<?= $basePath ?>/Public/Api/qr/generate.php?id=<?= $unit['id'] ?>&slug=<?= urlencode($unit['slug']) ?>"
               alt="Código QR"
               class="img-fluid"
               style="max-width:200px">
        </div>
    </div>

  </div>
</section>
