<?php
if (!headers_sent()) {
  header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
  header('Cache-Control: post-check=0, pre-check=0', false);
  header('Pragma: no-cache');
  header('Expires: 0');
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Admin • CampusMap') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#111; color:#fff; }
    .navbar { background:#000; }
    .btn-warning { background:#FFC107; border-color:#FFC107; color:#000; font-weight:700; }
    .card-dark { background:#000; border:1px solid #222; }
    .form-control, .form-select { background:#0f0f0f; border-color:#333; color:#fff; }
    .form-control::placeholder { color:#888; }
    .brand span:nth-child(1){ color:#fff; font-weight:800; }
    .brand span:nth-child(2){ color:#FFC107; font-weight:800; }
  </style>
</head>
<body>
<nav class="navbar px-3">
  <a class="navbar-brand brand" href="/admin/dashboard">
    <span>Campus</span><span>Map</span> <small class="text-secondary">Admin</small>
  </a>
  <div class="d-flex align-items-center gap-2">
    <?php if (!empty($_SESSION['admin_name'])): ?>
      <span class="text-secondary small d-none d-md-inline"><?= htmlspecialchars($_SESSION['admin_name']) ?></span>
      <a class="btn btn-sm btn-warning" href="<?= $basePath ?>/admin/logout" 
   onclick="return confirm('¿Deseas cerrar sesión?')">Cerrar sesión</a>

    <?php endif; ?>
  </div>
</nav>
