<?php
/** @var array $unit */
/** @var array $media */
?>

      <div class="row justify-content-around gy-4">
          <h2><?= htmlspecialchars($unit['name']) ?></h2>
        <div class="features-image col-lg-6" data-aos="fade-up" data-aos-delay="100">
              <?php if (!empty($media)):
                $m = $media[0] ?? null;
                if (($m['type'] ?? '') === 'video'):
                  $url  = $m['url'] ?? '';
                  $isYT = preg_match('~youtu\.be|youtube\.com~', $url); ?>
            <div class="player">
              <?php if ($isYT): ?>
                <iframe loading="lazy" width="560" height="315"
                  src="<?= htmlspecialchars($url) ?>" frameborder="0"
                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                  allowfullscreen></iframe>
              <?php else: ?>
                <video controls preload="metadata" width="100%">
                  <source src="<?= htmlspecialchars($url) ?>" type="video/mp4">
                  Tu navegador no soporta video HTML5.
                </video>
              <?php endif; ?>
            </div>
          <?php endif; endif; ?>
            
        </div>

        <div class="col-lg-5 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
          <h3>Descripción: </h3>
            <?php if (!empty($unit['description_short'])): ?>
                <p class="muted"><?= htmlspecialchars($unit['description_short']) ?></p>
            <?php endif; ?>
              <?php if (!empty($unit['description_steps'])):
                    $steps = preg_split('/\r?\n/', trim($unit['description_steps']));
              ?>
                <h3 style="color: #2F597A;">INDICACIONES</h3>
                <ol class="steps">
                  <?php foreach ($steps as $s): if (trim($s) !== ''): ?>
                    <li><?= htmlspecialchars($s) ?></li>
                  <?php endif; endforeach; ?>
                </ol>
              <?php endif; ?>
            
              <div class="grid">
                <div><strong>Edificio:</strong> <?= htmlspecialchars($unit['building'] ?? '-') ?></div>
                <div><strong>Piso:</strong> <?= htmlspecialchars($unit['floor'] ?? '-') ?></div>
                   <div class="actions">
                    <button class="btn yellow" id="btn-back">Nueva búsqueda</button>
                  </div>
              </div>
             </div>
        </div>