<!-- Lugares Section -->
<section id="projects" class="projects section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2>Selecciona dónde quieres ir</h2>
    <p>Haz clic sobre el lugar y se mostraran las indicaciones</p>
  </div>

  <div class="container">
    <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

      <!-- Filtros -->
      <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
        <li data-filter="*" class="filter-active">Todos</li>
        <?php if (!empty($areas) && is_array($areas)): ?>
          <?php foreach($areas as $area): ?>
            <li data-filter=".filter-<?= $area['slug'] ?>"><?= $area['name'] ?></li>
          <?php endforeach; ?>
        <?php endif; ?>
      </ul>

<!-- Galería -->
<div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">
  <?php foreach ($units as $unit): ?>
    <?php 
      $areaSlug = $unit['area_slug'] ?? 'sin-area'; 
      $hasVideo = !empty($unit['video']);
      $lightboxHref = $hasVideo ? $unit['video'] : $unit['image'];
      $lightboxIcon = $hasVideo ? 'bi-play-circle' : 'bi-zoom-in';
    ?>
    <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-<?= $areaSlug ?>">
      <div class="portfolio-content h-100">
        <img src="<?= $unit['image'] ?>" class="img-fluid" alt="<?= $unit['name'] ?>">
        <div class="portfolio-info">
          <h4><?= $unit['name'] ?></h4>
          <p><?= $unit['description_short'] ?></p>

          <!-- Lightbox Preview (image or video) -->
            <a href="<?= $lightboxHref ?>" 
               title="<?= $unit['name'] ?>" 
               data-gallery="portfolio-gallery-<?= $areaSlug ?>" 
               class="glightbox preview-link"
               data-unit-id="<?= $unit['id'] ?>"
               data-type="<?= $hasVideo ? 'video' : 'image' ?>">
              <i class="bi <?= $lightboxIcon ?>"></i>
            </a>

          <!-- Link a más detalles -->
          <a href="<?= $basePath ?>/unidad/<?= $unit['slug'] ?>" 
             title="Más detalles" 
             class="details-link">
            <i class="bi bi-link-45deg"></i>
          </a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div><!-- /isotope-container -->


    </div><!-- /isotope-layout -->
  </div><!-- /container -->
</section>
