<!-- Page Title -->
<div class="page-title dark-background" style="background-image: url(<?= $basePath ?>/assets/img/page-title-bg.jpg);">
  <div class="container position-relative">
    <h1><?= htmlspecialchars($title) ?></h1>
    <nav class="breadcrumbs">
      <ol>
        <li><a href="<?= $basePath ?>/">Inicio</a></li>
        <li><a href="<?= $basePath ?>/unidades">Todas</a></li>
        <li class="current"><?= htmlspecialchars($title) ?></li>
      </ol>
    </nav>
  </div>
</div>

<section id="area-units" class="starter-section section">
  <div class="container" data-aos="fade-up">
    <div class="row gy-4">
      <?php foreach ($units as $unit): ?>
        <div class="col-lg-4 col-md-6">
          <div class="card h-100">
            <?php if (!empty($unit['image'])): ?>
              <img src="<?= htmlspecialchars($unit['image']) ?>" class="card-img-top" alt="<?= $unit['name'] ?>">
            <?php endif; ?>
            <div class="card-body">
              <h5 class="card-title"><?= htmlspecialchars($unit['name']) ?></h5>
              <p class="card-text"><?= htmlspecialchars($unit['description_short']) ?></p>
              <a href="<?= $basePath ?>/unidad/<?= $unit['slug'] ?>" class="btn btn-primary">Ver detalles</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>
