<?php
$userName = htmlspecialchars($user['name'] ?? 'Administrador');
?>
<style>
/* ===== Dashboard look & feel (muvelo luego a assets/css/admin.css) ===== */
:root{
  --card-bg:#141414; --card-bd:#262626; --muted:#a0a0a0; --accent:#f8d13b;
  --ok:#5cb85c; --warn:#e67e22; --danger:#d9534f; --bar:#808080; --bar-track:#2a2a2a;
}
.card.shadow-sm{ background:var(--card-bg); border:1px solid var(--card-bd); box-shadow:0 1px 8px rgba(0,0,0,.28); }
.card .card-body{ padding:14px 14px 12px; }
.kpi-title{ font-size:.92rem; color:var(--muted); letter-spacing:.2px; margin-bottom:6px; }
.kpi-value{ font-size:1.9rem; font-weight:800; line-height:1.1; }
.kpi-sub{ font-size:.84rem; color:var(--muted); margin-top:4px; }
.kpi .muted{ color:var(--muted); font-weight:600; margin-left:6px; }
.kpi.ok .kpi-value{ color:var(--ok); } .kpi.warn .kpi-value{ color:var(--warn); } .kpi.danger .kpi-value{ color:var(--danger); }
.kpi-list .row{ display:flex; justify-content:space-between; padding:6px 0; border-bottom:1px dashed rgba(255,255,255,.06); }
.kpi-list .row:last-child{ border-bottom:0; } .kpi-list .name{ max-width:70%; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; }
.kpi-grid{ display:grid; grid-template-columns:repeat(3,1fr); gap:8px; } .kpi-grid .mini-title{ color:var(--muted); font-size:.78rem; }
.kpi-grid .mini-val{ font-size:1.15rem; font-weight:700; }
.funnel .stage{ margin:8px 0; padding:6px 8px; background:#171717; border:1px solid var(--card-bd); border-radius:10px; }
.funnel .label{ color:var(--muted); font-size:.85rem; } .funnel .value{ font-size:1.05rem; font-weight:700; }
.bars .bar{ margin:8px 0; } .bar-label{ font-size:.85rem; color:var(--muted); margin-bottom:4px; }
.bar-track{ height:10px; background:var(--bar-track); border-radius:6px; overflow:hidden; }
.bar-fill{ height:10px; background:linear-gradient(90deg,var(--bar),#bdbdbd); }
.is-loading .skeleton{ height:64px; border-radius:12px; background:linear-gradient(90deg,#1b1b1b,#2a2a2a,#1b1b1b); background-size:200% 100%; animation:sh 1.2s infinite; }
@keyframes sh{0%{background-position:200% 0}100%{background-position:-200% 0}}
.card-error{ font-size:.92rem; color:#ffb4b4; background:#361e1e; border:1px solid #5a2d2d; padding:10px; border-radius:10px; }
.dash-filters .form-label{ color:var(--muted); font-size:.82rem; }
.section-label{ letter-spacing:.08em; }
</style>

<div class="container-fluid">
  <!-- Encabezado + filtros -->
  <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
    <div>
      <h3 class="mb-1">Panel de control</h3>
      <div class="text-muted">Bienvenido, <strong><?= $userName ?></strong>.</div>
    </div>

    <div class="dash-filters d-flex align-items-end gap-2 flex-wrap">
      <div>
        <label for="start-date" class="form-label mb-1">Desde</label>
        <input id="start-date" type="date" class="form-control form-control-sm" />
      </div>
      <div>
        <label for="end-date" class="form-label mb-1">Hasta</label>
        <input id="end-date" type="date" class="form-control form-control-sm" />
      </div>
      <div class="pb-1">
        <button id="apply-range" class="btn btn-primary btn-sm fw-bold">Aplicar</button>
      </div>
    </div>
  </div>

  <!-- Seccin: Uso y descubrimiento -->
  <h6 class="text-uppercase text-muted mt-3 mb-2 section-label">Uso y descubrimiento</h6>
  <div class="row g-3">
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-searches" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-no-result" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-top-units" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-funnel" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
  </div>

  <!-- Seccin: Operativa -->
  <h6 class="text-uppercase text-muted mt-4 mb-2 section-label">Operativa</h6>
  <div class="row g-3">
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-ctr" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-route-requests" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-kiosk-sessions" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div id="card-catalog-hygiene" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
  </div>

  <!-- Seccin: Calidad y seguridad -->
  <h6 class="text-uppercase text-muted mt-4 mb-2 section-label">Calidad y seguridad</h6>
  <div class="row g-3">
    <div class="col-12 col-lg-4">
      <div id="card-security" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-lg-4">
      <div id="card-usage-by-channel" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
    <div class="col-12 col-lg-4">
      <div id="card-input-mode" class="card h-100 shadow-sm"><div class="card-body"></div></div>
    </div>
  </div>
</div>

<!-- Script del dashboard (archivo nico) -->
<script type="module" src="/campusmap/assets/js/admin-dashboard.js?v=1.0.0.0.0.0.0.0.0.0.0.0.0.1"></script>
