<?php
namespace App\Services;

use App\Models\UnitRepository;
use App\Models\MediaRepository;

class UnitService {
    private UnitRepository $units;
    private MediaRepository $media;

    public function __construct(array $config) {
        $this->units = new UnitRepository($config);
        $this->media = new MediaRepository($config);
    }

    // Obtener una unidad por slug (uso rápido)
    public function getBySlug(string $slug): ?array {
        return $this->units->getBySlug($slug);
    }

    //️ Obtener medios asociados a una unidad
    //public function getMedia(int $unitId): array {
       // return $this->media->getByUnit($unitId);
    //}
    
    public function getMedia(int $unitId): array {
    $media = $this->media->getByUnit($unitId);

    foreach ($media as &$m) {
        if ($m['type'] === 'video') {
            $m['url'] = \App\Helpers\VideoHelper::toEmbedUrl($m['url']);
        }
    }
    unset($m);

    return $media;
}


    // Listar todas las unidades agrupadas con áreas
    public function getAllWithAreas(): array {
        return $this->units->getAllWithAreas();
    }

    // Registrar acción de reproducción
    public function logPlay(int $unitId, string $source): void {
        $this->units->logStat($unitId, 'play', $source);
    }

    //  Registrar aparición de un solo unit
    public function logAppearance(int $unitId, string $source): void {
        $this->units->logStat($unitId, 'appearance', $source);
    }

    // Registrar aparición de múltiples units (ej: listados)
    public function logAppearances(array $unitIds, string $source): void {
        foreach ($unitIds as $id) {
            $this->units->logStat($id, 'appearance', $source);
        }
    }

    // Listar unidades por área
    public function getByAreaSlug(string $slug): array {
        return $this->units->getByAreaSlug($slug);
    }

    // Paginación de unidades
    public function getAllUnits(int $limit, int $offset): array {
        return $this->units->fetchAllUnits($limit, $offset);
    }

    // Obtener detalle completo de una unidad (con imágenes/videos)
    public function getUnitDetail(?int $unitId, ?string $slug): ?array {
        $rows = $this->units->fetchUnitByIdOrSlug($unitId, $slug);

        if (!$rows) {
            return null;
        }

        $u = $rows[0]; // fila base de la unidad
        $unit = [
            'id'                => $u['id'],
            'slug'              => $u['slug'],
            'name'              => $u['name'],
            'alias'             => $u['alias'],
            'building'          => $u['building'],
            'floor'             => $u['floor'],
            'description_short' => $u['description_short'],
            'description_steps' => $u['description_steps'],
            'area_id'           => $u['area_id'],
            'area_name'         => $u['area_name'],
            'area_slug'         => $u['area_slug'],
            'images'            => [],
            'videos'            => [],
            'web_url'           => "/unidad/" . $u['slug']
        ];

        foreach ($rows as $row) {
            if ($row['media_type'] === 'image') {
                $unit['images'][] = $row['media_url'];
            } elseif ($row['media_type'] === 'video') {
                $unit['videos'][] = $row['media_url'];
            }
        }

        return $unit;
    }
    
    public function getUnitSummary(int $unitId): ?array {
    return $this->units->getSummaryById($unitId);
}

}
