<?php
namespace App\Services;

class NLP {
  // Quita tildes y normaliza
  public static function normalize(string $text): string {
    $t = mb_strtolower($text, 'UTF-8');
    $t = self::removeAccents($t);
    $t = trim(preg_replace('/\s+/', ' ', $t));
    return $t;
  }

  public static function removeAccents(string $s): string {
    $from = 'áàäâãéèëêíìïîóòöôõúùüûñ';
    $to   = 'aaaaaeeeeiiiiooooouuuun';
    return strtr($s, array_combine(
      preg_split('//u', $from, -1, PREG_SPLIT_NO_EMPTY),
      preg_split('//u', $to, -1, PREG_SPLIT_NO_EMPTY)
    ));
  }

  public static function removeStopwords(string $t): string {
    $stop = ['donde','dónde','esta','está','la','el','de','del','unidad','quiero','saber','ir','como','cómo','esta','esta'];
    $parts = array_filter(explode(' ', $t), fn($w)=>!in_array($w,$stop));
    return implode(' ', $parts);
  }
}
