<?php
namespace App\Services;

use App\Models\UnitRepository;

class MenuService {
  private UnitRepository $units;

  public function __construct(array $config) {
    $this->units = new UnitRepository($config);
  }

  public function getMenuTree(): array {
    $rawData = $this->units->getAllGroupedByArea();
    $menu = [];

    foreach ($rawData as $row) {
      $area = $row['area_name'];
      if (!isset($menu[$area])) {
        $menu[$area] = [];
      }
      $menu[$area][] = [
        'id' => $row['unit_id'],
        'name' => $row['unit_name'],
        'slug' => $row['unit_slug']
      ];
    }

    return $menu;
  }
}
