<?php
namespace App\Models;
use App\Core\Database;

class SynonymRepository {
  private \PDO $db;
  public function __construct(array $config){ $this->db = Database::pdo($config); }

  public function findExact(string $term): ?array {
    $st = $this->db->prepare("
      SELECT u.id, u.name, u.alias, u.slug
      FROM unit_synonyms s
      JOIN units u ON u.id = s.unit_id
      WHERE u.is_active=1 AND LOWER(s.term)=?
      LIMIT 1
    ");
    $st->execute([$term]);
    return $st->fetch() ?: null;
  }

  public function likeTerms(string $q, int $limit=5): array {
    $st = $this->db->prepare("
      SELECT DISTINCT s.term FROM unit_synonyms s
      WHERE s.term LIKE ?
      LIMIT $limit
    ");
    $st->execute(['%'.$q.'%']);
    return $st->fetchAll();
  }
}
