<?php
namespace App\Models;

use App\Core\Database;
use PDO;

class KioskRepository {
    private PDO $db;

    public function __construct(array $config) {
        $this->db = Database::pdo($config);
    }

    public function createSession(string $role, string $token): void {
        $sql = "INSERT INTO kiosk_sessions (role, session_token) VALUES (?, ?)";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$role, $token]);
    }

    public function logAction(string $session, string $action, ?int $unitId = null): void {
        $sql = "INSERT INTO kiosk_stats (session_token, unit_id, action) VALUES (?, ?, ?)";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$session, $unitId, $action]);
    }
}
