<?php
namespace App\Helpers;

class VideoHelper {
    public static function toEmbedUrl(string $url): string {
        if (str_contains($url, 'watch?v=')) {
            $id = explode('watch?v=', $url)[1];
            return "https://www.youtube.com/embed/" . $id;
        }
        if (str_contains($url, 'youtu.be/')) {
            $id = explode('youtu.be/', $url)[1];
            return "https://www.youtube.com/embed/" . $id;
        }
        // Si ya es embed o un ID puro
        if (!str_contains($url, 'http')) {
            return "https://www.youtube.com/embed/" . $url;
        }
        return $url;
    }
}
