<?php
namespace App\Core;
class Controller {
  protected array $config;
  public function __construct(array $config){ $this->config = $config; }

protected function view(string $name, array $data = [], string $layout = 'theme/layout'): void {
    $basePath  = $this->config['base_path'] ?? '';
    $title     = $data['title'] ?? 'CampusMap';
    if (!empty($data)) extract($data, EXTR_SKIP);

    $viewName  = $name;
    $viewFile  = __DIR__ . '/../Views/' . $viewName . '.php';

    // Detecta si la vista pertenece al admin
    if (str_starts_with($name, 'admin/')) {
        $layout = 'theme/admin_theme/layout_admin';
    }

    $layoutFile = __DIR__ . '/../Views/' . $layout . '.php';

    if (!is_file($viewFile))  { http_response_code(500); echo "Vista no encontrada: $viewFile";  return; }
    if (!is_file($layoutFile)){ http_response_code(500); echo "Layout no encontrado: $layoutFile"; return; }

    require $layoutFile;
}



  protected function json($payload, int $code=200): void {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($payload, JSON_UNESCAPED_UNICODE);
  }
}
