<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Services\UnitService;
use App\Services\MenuService;
use App\Helpers\VideoHelper;

class UnitController extends Controller {
  public function ver(string $slug): void {
    $svc  = new UnitService($this->config);
    $unit = $svc->getBySlug($slug);
    $menuService = new MenuService($this->config); 

    if (!$unit) {
      http_response_code(404);
      echo 'Unidad no encontrada';
      return;
    }

    // Diferenciar registro: bsqueda vs acceso directo
    if (isset($_GET['from']) && $_GET['from'] === 'search') {
      $svc->logPlay($unit['id'], 'search');
    } else {
      $svc->logAppearance($unit['id'], 'unit');
    }
    
    // Obtener media relacionado
    $media = $svc->getMedia($unit['id']);
    
    // Si es AJAX (partial)
    if (isset($_GET['partial'])) {
      require __DIR__ . '/../Views/partials/unit_inline.php';
      return;
    }

    // Vista normal
    $menu = $menuService->getMenuTree(); 
    $this->view('unit_detail', ['title'=>$unit['name'], 'unit'=>$unit, 'media'=>$media, 'menu'=>$menu], 'theme/unit_theme/layout');


  }
}
