<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Services\SearchService;

class SearchController extends Controller {
  public function buscar(): void {
    try {
      $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
      $q      = trim($_GET['q'] ?? $_POST['q'] ?? '');   // <-- lee GET y POST
      $source = $_GET['source'] ?? $_POST['source'] ?? 'text';
      if ($source !== 'voice' && $source !== 'text') $source = 'text';

      if ($q === '') {
        $this->json(['type'=>'error','message'=>'Falta q'], 400);
        return;
      }

      $svc    = new SearchService($this->config);
      $result = $svc->match($q, $source);
      
     // Registrar apariciones si hay resultados
      $ids = array_column($result['matches'] ?? [], 'id');
      if (!empty($ids)) {
        $svc->logAppearances($ids, 'search');
      }
      
      $this->json($result);
    } catch (\Throwable $e) {
      @file_put_contents(dirname(__DIR__,2).'/storage/error.log',
        date('c').' '.$e->getMessage().' @ '.$e->getFile().':'.$e->getLine()."\n", FILE_APPEND);
      $this->json(['type'=>'error','message'=>'Server error'], 500);
    }
  }
}
