<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Services\MenuService;

class InfoController extends Controller {
    public function instrucciones(): void {
        $menuService = new MenuService($this->config);
        $menu = $menuService->getMenuTree();
        
        $this->view('instrucciones', [
            'title' => 'Instrucciones',
            'menu'  => $menu,
            'breadcrumbs' => [
                ['label' => 'Inicio', 'href' => $this->config['base_path'] . '/'],
                ['label' => 'Instrucciones']
            ]
        ], 'theme/layout');
    }
}