<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Services\UnitService;
use App\Services\MenuService;

class HomeController extends Controller {
  public function index(): void {
    $unitService = new UnitService($this->config);
    $menuService = new MenuService($this->config); // 

    // Obtener todas las unidades con su área asociada
    $units = $unitService->getAllWithAreas();

    // Extraer áreas únicas desde las unidades
    $areas = [];
    foreach ($units as $unit) {
      if (!empty($unit['area_slug']) && !isset($areas[$unit['area_slug']])) {
        $areas[$unit['area_slug']] = [
          'slug' => $unit['area_slug'],
          'name' => $unit['area_name'] ?? ucfirst($unit['area_slug'])
        ];
      }
    }

    // Obtener menú dinámico agrupado por área
    $menu = $menuService->getMenuTree();

    // Renderizar la vista principal
    $this->view('home', [
      'title' => 'CampusMap',
      'units' => $units,
      'areas' => array_values($areas),
      'menu' => $menu,                // <-- 
      'includeVoice' => true
    ]);
  }
}
