<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Services\UnitService;
use App\Services\MenuService;

class AreaController extends Controller {
    
    // Todas las unidades (independiente del área)
    public function todas(int $page = 1): void {
        $svc   = new UnitService($this->config);
        $menuService = new MenuService($this->config); 
        $limit = 12; // unidades por página
        $offset = ($page - 1) * $limit;

        $data = $svc->getAllUnits($limit, $offset);
        $menu = $menuService->getMenuTree(); 

        $this->view('units_all', [
            'title' => 'Todas las unidades',
            'unitsa' => $data['unitsa'],
            'total' => $data['total'],
            'page'  => $page,
            'menu'  => $menu,
            'limit' => $limit
        ]);
    }
  
  // Ver solo unidades de un área específica
  public function ver(string $slug): void {
    $svc  = new UnitService($this->config);
    $menuService = new MenuService($this->config); 

    // Traer todas las unidades de la categoría
    $units = $svc->getByAreaSlug($slug);
    

    if (empty($units)) {
      http_response_code(404);
      echo 'Categoría no encontrada';
      return;
    }

    // Todas las unidades devueltas tienen el mismo área
    $areaName = $units[0]['area_name'];
    $menu = $menuService->getMenuTree(); 

    $this->view('area_units', [
      'title' => $areaName,
      'units' => $units,
      'area'  => $slug,
      'menu'  => $menu,
      'breadcrumbs' => [
        ['label' => 'Inicio', 'href' => $this->config['base_path'] . '/'],
        ['label' => $areaName]
      ]
    ], 'theme/unit_theme/layout');
  }
}
