<?php
namespace App\Controllers\Api;

use App\Core\Controller;
use App\Services\KioskService;

class KioskController extends Controller {
    private KioskService $svc;

    public function __construct(array $config) {
        parent::__construct($config);
        $this->svc = new KioskService($config);
    }

    public function start(): void {
        $role = $_POST['role'] ?? '';
        $validRoles = ['visitante', 'empleado', 'estudiante'];

        if (!in_array($role, $validRoles)) {
            http_response_code(400);
            echo json_encode(['error' => 'Rol inválido']);
            return;
        }

        $token = $this->svc->startSession($role);

        header('Content-Type: application/json');
        echo json_encode([
            'session_token' => $token,
            'role' => $role
        ]);
    }

public function voice(): void {
    $session = $_POST['session_token'] ?? '';
    $text    = trim($_POST['text'] ?? '');

    if ($session === '' || $text === '') {
        http_response_code(400);
        echo json_encode(['error' => 'Parámetros inválidos']);
        return;
    }

    $match = $this->svc->handleVoice($session, $text);

    header('Content-Type: application/json');

    if (!$match) {
        echo json_encode(['found'=>false,'message'=>'Unidad no encontrada']);
        return;
    }

if ($match['type'] === 'single') {
    $u = $this->svc->getUnitSummary($match['unit']['id']); // nuevo método
    echo json_encode([
        'found'       => true,
        'type'        => 'single',
        'id'          => $u['id'],
        'slug'        => $u['slug'],
        'name'        => $u['name'],
        'alias'       => $u['alias'],
        'description' => $u['description_short'],
        'image_url'   => $u['image_url'],
        'youtube_url' => $u['youtube_url']
    ]);
}
elseif ($match['type'] === 'multiple') {
    $results = [];
    foreach ($match['results'] as $r) {
        $u = $this->svc->getUnitSummary($r['id']);
        if ($u) $results[] = $u;
    }
    echo json_encode([
        'found'   => true,
        'type'    => 'multiple',
        'results' => $results
    ]);
}

    else {
        echo json_encode([
            'found'       => false,
            'type'        => 'none',
            'suggestions' => $match['suggestions'] ?? []
        ]);
    }
}

public function action(): void {
        $session = $_POST['session_token'] ?? '';
        $action  = $_POST['action'] ?? '';
        $unitId  = (int)($_POST['unit_id'] ?? 0);

        $valid = ['appearance', 'play', 'qr_scan'];

        if ($session === '' || !in_array($action, $valid)) {
            http_response_code(400);
            echo json_encode(['error' => 'Parámetros inválidos']);
            return;
        }

        $this->svc->logAction($session, $action, $unitId > 0 ? $unitId : null);

        header('Content-Type: application/json');
        echo json_encode(['ok' => true, 'action' => $action]);
    }
    
public function unit(): void {
    $session = $_POST['session_token'] ?? '';
    $unitId  = isset($_POST['unit_id']) ? (int)$_POST['unit_id'] : null;
    $slug    = $_POST['slug'] ?? null;

    if ($session === '' || (!$unitId && !$slug)) {
        http_response_code(400);
        echo json_encode(['error' => 'Parámetros inválidos']);
        return;
    }

    $unit = $this->svc->getUnitDetail($unitId, $slug);

    header('Content-Type: application/json');

    if (!$unit) {
        echo json_encode(['found' => false, 'message' => 'Unidad no encontrada']);
        return;
    }

    $this->svc->logAction($session, "appearance", $unit['id']);

    echo json_encode([
        'found' => true,
        'type'  => 'single',
        'unit'  => $unit
    ]);
}


}
