<?php
namespace App\Controllers\Admin;

use App\Core\Controller;
use App\Services\Admin\AuthService;

class LoginController extends Controller {
  public function login(): void {
    $auth  = new AuthService($this->config);
    $error = null;

    if ($_SERVER['REQUEST_METHOD']==='POST') {
      $email = trim($_POST['email'] ?? '');
      $pass  = $_POST['password'] ?? '';
      $res   = $auth->login($email, $pass);
      if ($res['success']) { header('Location: /campusmap/admin/dashboard'); exit; }
 
      $error = $res['message'] ?? 'Credenciales inválidas';
    }

    $this->view('admin/login', ['title'=>'Acceso administrativo','error'=>$error]);
  }

public function logout(): void {
    $auth = new \App\Services\Admin\AuthService($this->config);
    $auth->logout();
    header('Location: /campusmap/admin/login');
    exit;
}

}
