<?php
namespace App\Controllers\Admin;

use App\Core\Controller;
use App\Services\Admin\AuthService;

class DashboardController extends Controller
{
    public function index(): void {
        $auth = new AuthService($this->config);
        $user = $auth->check();

        if (!$user) {
            header('Location: /campusmap/admin/login');
            exit;
        }

        $this->view('admin/dashboard', [
            'title' => 'Panel de control',
            'user'  => $user
        ]);
    }
}
